; Back.s : 背景
;


; モジュール宣言
;
    .module Back

; 参照ファイル
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include    "Sound.inc"
    .include    "App.inc"
    .include    "Game.inc"
    .include	"Back.inc"

; 外部変数宣言
;

; マクロの定義
;


; CODE 領域
;
    .area   _CODE

; 背景を初期化する
;
_BackInitialize::
    
    ; レジスタの保存
    
    ; 背景の初期化
    ld      hl, #backDefault
    ld      de, #_back
    ld      bc, #BACK_LENGTH
    ldir

;   ; 状態の設定
;   ld      a, #BACK_STATE_NULL
;   ld      (_back + BACK_STATE), a
    
    ; レジスタの復帰
    
    ; 終了
    ret

; 背景を更新する
;
_BackUpdate::
    
    ; レジスタの保存

    ; 初期化
    ld      a, (_back + BACK_STATE)
    or      a
    jr      nz, 09$

    ; 街並みの表示
    call    BackPrintCity

    ; 初期化の完了
    ld      hl, #(_back + BACK_STATE)
    inc     (hl)
09$:

    ; レジスタの復帰
    
    ; 終了
    ret

; 背景を描画する
;
_BackRender::

    ; レジスタの保存

    ; レジスタの復帰

    ; 終了
    ret

; 街並みを表示する
;
BackPrintCity:

    ; レジスタの保存

    ; パターンネームの描画
    ld      hl, #backCityPatternName
    ld      de, #(_patternName + 0x0004)
    ld      b, #0x18
10$:
    push    bc
    ld      bc, #0x0018
    ldir
    ex      de, hl
    ld      bc, #0x0008
    add     hl, bc
    ex      de, hl
    pop     bc
    djnz    10$

    ; レジスタの復帰

    ; 終了
    ret

; 定数の定義
;

; 背景の初期値
;
backDefault:

    .db     BACK_STATE_NULL
    .db     BACK_FLAG_NULL

; 街並み
;
backCityPatternName:

    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa2, 0xa3, 0xa4, 0xa5, 0xa1
    .db     0xa1, 0xa6, 0xa7, 0xa8, 0xa9, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xaa, 0xab, 0xac, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xad, 0xae, 0xaf, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xb0, 0xb1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xb2, 0xb3, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xb4, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xb5, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xb6, 0xa1, 0xa1, 0xa1, 0xe0, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xb7, 0xa0, 0xa0
    .db     0xa0, 0xb8, 0xb9, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xe0, 0xa1, 0xba, 0xbb, 0xa0
    .db     0xa0, 0xbc, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xbd, 0xa0
    .db     0xbe, 0xbf, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xc0, 0xc1
    .db     0xc2, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xe0, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xc3
    .db     0xc4, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xe0, 0xa1, 0xa1, 0xc5
    .db     0xc6, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xc7
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xe0, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xc8, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xe0, 0xc9
    .db     0xca, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1
    .db     0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xcb
    .db     0xcc, 0xa1, 0xf0, 0xf1, 0xf2, 0xf3, 0xa1, 0xa1, 0xa1, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xa1, 0xcd
    .db     0xce, 0xcf, 0xf8, 0xf9, 0xfa, 0xfb, 0xa1, 0xa1, 0xa1, 0xa0, 0xe8, 0xe8
    .db     0xa0, 0xa0, 0xa1, 0xa1, 0xa0, 0xa0, 0xa1, 0xa1, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xd0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa1, 0xa1, 0xa1, 0xa0, 0xe8, 0xe8
    .db     0xe8, 0xa0, 0xa1, 0xa0, 0xa0, 0xa0, 0xa0, 0xa1, 0xa0, 0xa0, 0xe9, 0xa0
    .db     0xa0, 0xd1, 0xa0, 0xe8, 0xe8, 0xa0, 0xa1, 0xa1, 0xa1, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa1, 0xa0, 0xe8, 0xe8, 0xa0, 0xa1, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xe8, 0xe8, 0xa0, 0xa1, 0xa1, 0xa1, 0xa0, 0xe8, 0xe8
    .db     0xe8, 0xa0, 0xa1, 0xa0, 0xe8, 0xe8, 0xa0, 0xa1, 0xa0, 0xea, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xeb, 0xe8, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa1, 0xa0, 0xa0, 0xe8, 0xa0, 0xa1, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa1, 0xa0, 0xa0, 0xa0, 0xa0, 0xd2, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0
    

; DATA 領域
;
    .area   _DATA

; 変数の定義
;

; 背景
;
_back::
    
    .ds     BACK_LENGTH

